//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiToolButtonBase {
    id : uiToolButton

    property alias iconName : icon.iconName
    property alias text     : label.text
    property alias tooltip  : tooltip.text
    property alias iconSize : icon.iconSize

    property bool down : false

    implicitHeight   : label.y + label.implicitHeight + 8
    implicitWidth    : 82
    activeFocusOnTab : false

    UiTooltip { id : tooltip }

    Rectangle {
         id : background

         color        : UiColors.getColor(UiColors.White)
         anchors.fill : uiToolButton
         antialiasing : uiToolButton.antialiasing
         border {
             width : 1
             color : UiColors.getColor(UiColors.Black, .1)
         }

         states : [
             State {
                 name : "pressed"
                 when : uiToolButton.pressed

                 PropertyChanges {
                     target  : background
                     color   : UiColors.getColor(UiColors.SelectionGreen)
                     visible : true
                 }
             },
             State {
                 name : "hovered"
                 when : uiToolButton.hovered || uiToolButton.activeFocus

                 PropertyChanges {
                     target  : background
                     color   : UiColors.getColor(UiColors.HoverGreen)
                 }
             }
         ]
     }

     UiIcon {
        id : icon

        y        : 8
        iconSize : UiIcon.Icon_32x32
        anchors {
            horizontalCenter : uiToolButton.horizontalCenter
        }

        states : [
            State {
                name : "disabled"
                when : !uiToolButton.enabled

                PropertyChanges {
                    target   : icon
                    disabled : 1.0
                }
            },
            State {
                name : "highlight"
                when : uiToolButton.pressed || uiToolButton.down

                PropertyChanges {
                    target    : icon
                    highlight : 1.0
                }
            }
        ]
    }
    UiText {
        id : label

        highlight : uiToolButton.pressed

        anchors {
            baseline         : uiToolButton.top
            baselineOffset   : 54
            left             : uiToolButton.left
            leftMargin       : 7
            right            : uiToolButton.right
            rightMargin      : 7
        }
        horizontalAlignment : Qt.AlignHCenter
        elide    : Text.ElideRight
        wrapMode : Text.Wrap
    }
}

